/* 
 *  KVPItem.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldI;
import com.avaya.ccs.api.CustomFieldListI;
import com.avaya.ccs.api.DataI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KVPItem {

    private final String name;
    private final String value;
    private final boolean readOnly;

    public KVPItem(String name, String value, boolean readOnly) {
        this.name = name;
        this.value = value;
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isReadOnly() {
        return readOnly;
    }

    public static List<KVPItem> convertIntrinsicsList(List<IntrinsicElement> intrinsics) {
        List<KVPItem> newList = new ArrayList<>();
        for (IntrinsicElement i : intrinsics) {
            newList.add(new KVPItem(i.getName(), i.getValue(), i.isReadOnly()));
        }
        return newList;
    }

    public static List<KVPItem> convertCustomFieldsList(CustomFieldListI customFields) {
        List<KVPItem> newList = new ArrayList<>();
        for (CustomFieldI i : customFields.getCustomFields()) {
            newList.add(new KVPItem(i.getName(), i.getValue(), true));
        }
        return newList;
    }

    public static List<KVPItem> convertKVPData(DataI data) {
        List<KVPItem> newList = new ArrayList<>();
        if (data == null) {
            return newList;
        }

        Map<String, String> kvps = data.getKvpData();
        if (kvps == null) {
            return newList;
        }

        for (Map.Entry<String, String> i : kvps.entrySet()) {
            newList.add(new KVPItem((String) i.getKey(), (String) i.getValue(), false));
        }
        return newList;
    }
}
